<?php

require 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->boot();

echo "Creating Super Admin and Regular Admin...\n";

// Create default tenant
$tenant = \App\Models\Tenant::firstOrCreate([
    'domain' => 'main.store'
], [
    'name' => 'Main Store',
    'database' => 'main'
]);

echo "Tenant created: {$tenant->name}\n";

// Delete existing users
\App\Models\User::whereIn('email', ['admin@admin.com', 'superadmin@admin.com'])->delete();

// Create regular admin
$admin = \App\Models\User::create([
    'name' => 'Admin',
    'email' => 'admin@admin.com',
    'password' => \Hash::make('admin123'),
    'tenant_id' => $tenant->id
]);

// Create super admin
$superAdmin = \App\Models\User::create([
    'name' => 'Super Admin',
    'email' => 'superadmin@admin.com',
    'password' => \Hash::make('superadmin123'),
    'tenant_id' => $tenant->id
]);

echo "\n✅ Users created successfully!\n";
echo "📧 Regular Admin: admin@admin.com / admin123\n";
echo "👑 Super Admin: superadmin@admin.com / superadmin123\n";
echo "🌐 Login at: http://127.0.0.1:8001/login\n";
echo "🏢 Tenant: {$tenant->name}\n";